/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * EnumerateChecker.hpp
 *
 *  Created on: Dec 18, 2010
 *      Author: derrickstolee
 */

#ifndef ENUMERATECHECKER_HPP_
#define ENUMERATECHECKER_HPP_

#include "nausparse.h"
#include "SolutionChecker.hpp"

class EnumerateChecker : public SolutionChecker
{
protected:
	/**
	 * N the number of vertices we are looking for
	 */
	int N;

	/**
	 * minE the minimum number of edges.
	 */
	int minE;

	/**
	 * maxE the maximum number of edges.
	 */
	int maxE;

public:

	/**
	 * Constructor
	 */
	EnumerateChecker(int N, int minE, int maxE);

	/**
	 * Destructor
	 */
	virtual ~EnumerateChecker();


	/**
	 * isSolution -- take a graph and check for a solution.
	 * Return a string of data if it is a solution.
	 *
	 * @param parent the parent EarNode -- contains adjacent children already considered
	 * @param child the child EarNode -- all data for the current node
	 * @return a string of data, if it is a solution.  0 if not.
	 */
	virtual char* isSolution(EarNode* parent, EarNode* child, int depth);
};

#endif /* ENUMERATECHECKER_HPP_ */
