/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * EnumerateDeleter.hpp
 *
 *  Created on: Dec 18, 2010
 *      Author: derrickstolee
 */

#ifndef ENUMERATEDELETER_HPP_
#define ENUMERATEDELETER_HPP_

#include "EarDeletionAlgorithm.hpp"

class EnumerateDeleter : public EarDeletionAlgorithm
{
public:
	/**
	 * Constructor
	 */
	EnumerateDeleter();

	/**
	 * Destructor
	 */
	virtual ~EnumerateDeleter();


	/**
	 * getCanonical -- return the index of the canonical ear-deletion
	 * for the given parent/child.
	 *
	 * The child contains the necessary graph/ear information.
	 *
	 * @param parent the parent EarNode
	 * @param child the child EarNode
	 * @return the index of the ear to use.
	 */
	virtual int getCanonical(EarNode* parent, EarNode* child);
};

#endif /* ENUMERATEDELETER_HPP_ */
