/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * EnumeratePruner.cpp
 *
 *  Created on: Dec 18, 2010
 *      Author: derrickstolee
 */

#include <stdlib.h>
#include "EnumeratePruner.hpp"

/**
 * Constructor
 */
EnumeratePruner::EnumeratePruner(int N, int minE, int maxE)
{
	this->N = N;
	this->minE = minE;
	this->maxE = maxE;
}

/**
 * Destructor
 */
EnumeratePruner::~EnumeratePruner()
{

}

/**
 * checkPrune -- check if the given graph needs to be pruned.
 *
 * @param graph a sparsegraph to check.
 * @return 1 iff the graph should be pruned.
 */
int EnumeratePruner::checkPrune(EarNode* parent, EarNode* child)
{
	if ( child->graph == 0 )
	{
		return 0;
	}

	if ( child->graph->nv > this->N )
	{
		/* too many vertices */
		return 1;
	}
	else if ( child->graph->nv < this->N && 2 + child->graph->nde + 2
			* (this->N - child->graph->nv) > 2 * this->maxE )
	{
		/* we need more vertices, so at least one ear (+2 edges) */
		/* and more edges (1 for every new vertex) */
		return 1;
	}
	else if ( child->graph->nde > 2 * this->maxE )
	{
		return 1;
	}

	return 0;
}
