/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * EnumeratePruner.hpp
 *
 *  Created on: Dec 18, 2010
 *      Author: derrickstolee
 */

#ifndef ENUMERATEPRUNER_HPP_
#define ENUMERATEPRUNER_HPP_

#include "nausparse.h"
#include "PruningAlgorithm.hpp"

class EnumeratePruner : public PruningAlgorithm
{
protected:
	/**
	 * N the number of vertices we are looking for
	 */
	int N;

	/**
	 * minE the minimum number of edges.
	 */
	int minE;

	/**
	 * maxE the maximum number of edges.
	 */
	int maxE;

public:

	/**
	 * Constructor
	 */
	EnumeratePruner(int N, int minE, int maxE);

	/**
	 * Destructor
	 */
	virtual ~EnumeratePruner();

	/**
	 * checkPrune -- check if the given graph needs to be pruned.
	 *
	 * @param graph a sparsegraph to check.
	 * @return 1 iff the graph should be pruned.
	 */
	int checkPrune(EarNode* parent, EarNode* child);
};

#endif /* ENUMERATEPRUNER_HPP_ */
