/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * MatchingChecker.hpp
 *
 *  Created on: Oct 15, 2010
 *      Author: derrickstolee
 */


#ifndef MATCHINGCHECKER_HPP_
#define MATCHINGCHECKER_HPP_

#include "nausparse.h"
#include "SolutionChecker.hpp"

class MatchingChecker : public SolutionChecker
{
	/**
	 * p the number of perfect matchings we are looking for.
	 */

	int pmin;
	int pmax;

	/**
	 * n the maximum number of vertices allowed.
	 */
	int n;

	/**
	 * c the constant we are attempting to attain
	 */
	int c;

public:
	/**
	 * Constructor
	 *
	 * @param p the number of perfect matchings we are looking for.
	 * @param n the maximum number of vertices allowed.
	 * @param c the constant wea re attempting to attain.
	 */
	MatchingChecker(int pmin, int pmax, int n, int c);

	/**
	 * Destructor
	 */
	virtual ~MatchingChecker();


	/**
	 * isSolution -- take a graph and check for a solution.
	 * Return a string of data if it is a solution.
	 *
	 * @param parent the parent EarNode -- contains adjacent children already considered
	 * @param child the child EarNode -- all data for the current node
	 * @return a string of data, if it is a solution.  0 if not.
	 */
	virtual char* isSolution(EarNode* parent, EarNode* child, int depth);
};

#endif /* MATCHINGCHECKER_HPP_ */
