/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * MatchingPruner.hpp
 *
 *  Created on: Oct 15, 2010
 *      Author: derrickstolee
 */

#ifndef MATCHINGPRUNER_HPP_
#define MATCHINGPRUNER_HPP_

#include "nausparse.h"
#include "EarNode.hpp"
#include "PruningAlgorithm.hpp"

class MatchingPruner : public PruningAlgorithm
{
	/**
	 * p the number of perfect matchings we are looking for.
	 */

	int pmin;
	int pmax;

	/**
	 * n the maximum number of vertices allowed.
	 */
	int n;

	int c;

public:
	/**
	 * Constructor
	 *
	 * @param p the number of perfect matchings we are looking for.
	 * @param n the maximum number of vertices allowed.
	 */
	MatchingPruner(int pmin, int pmax, int n, int c);

	/**
	 * Destructor
	 */
	virtual ~MatchingPruner();

	/**
	 * checkPrune -- check if the given graph needs to be pruned.
	 *
	 * @param graph a sparsegraph to check.
	 * @return 1 iff the graph should be pruned.
	 */
	int checkPrune(EarNode* parent, EarNode* child);
};

#endif /* MATCHINGPRUNER_HPP_ */
