/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * PruningAlgorithm.hpp
 *
 *  Created on: Oct 15, 2010
 *      Author: derrickstolee
 */

#ifndef PRUNINGALGORITHM_HPP_
#define PRUNINGALGORITHM_HPP_

#include "nausparse.h"
#include "EarNode.hpp"

class PruningAlgorithm
{
public:
	virtual ~PruningAlgorithm();

	/**
	 * checkPrune -- check if the given graph needs to be pruned.
	 *
	 * @return 1 iff the graph should be pruned.
	 */
	virtual int checkPrune(EarNode* parent, EarNode* child) = 0;
};

#endif /* PRUNINGALGORITHM_HPP_ */
