/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * ReconstructionPruner.hpp
 *
 *  Created on: Oct 15, 2010
 *      Author: derrickstolee
 */

#ifndef RECONSTRUCTIONPRUNER_HPP_
#define RECONSTRUCTIONPRUNER_HPP_

#include "nausparse.h"
#include "PruningAlgorithm.hpp"

class ReconstructionPruner : public PruningAlgorithm
{
	/**
	 * n the maximum number of vertices allowed.
	 */
	int n;

	/**
	 * logFacts
	 * Stores the list of numbers 1+log2(n!) for correct values of n.
	 */
	int* logFacts;

public:
	/**
	 * Constructor
	 *
	 * @param n the maximum number of vertices allowed.
	 */
	ReconstructionPruner(int n);

	/**
	 * Destructor
	 */
	virtual ~ReconstructionPruner();

	/**
	 * checkPrune -- check if the given graph needs to be pruned.
	 *
	 * @param graph a sparsegraph to check.
	 * @return 1 iff the graph should be pruned.
	 */
	int checkPrune(EarNode* parent, EarNode* child);
};


#endif /* RECONSTRUCTIONPRUNER_HPP_ */
