/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * SolutionChecker.cpp
 *
 *  Created on: Jan 20, 2011
 *      Author: derrickstolee
 */

#include "nausparse.h"
#include "SolutionChecker.hpp"
#include <stdlib.h>
#include <string.h>

/**
 * constructor
 *
 * Initializes num_solutions_at with max_depth positions, all set to 0.
 */
SolutionChecker::SolutionChecker(int max_depth)
{
	this->max_depth = max_depth;
	this->require_all_siblings = false;
	this->num_solutions_at = (int*) malloc(max_depth * sizeof(int));
	bzero(this->num_solutions_at, max_depth * sizeof(int));
}

/**
 * Destructor
 *
 * Frees num_solutions_at
 */
SolutionChecker::~SolutionChecker()
{
	if ( this->num_solutions_at != 0 )
	{
		free(this->num_solutions_at);
		this->num_solutions_at = 0;
	}
}

/**
 * getNumSolutionsAt
 *
 * @param i the position for the number of solutions.
 */
int SolutionChecker::getNumSolutionsAt(int i)
{
	if ( i < 0 || i >= this->max_depth )
	{
		return 0;
	}

	return this->num_solutions_at[i];
}

/**
 * getMaxDepth
 */
int SolutionChecker::getMaxDepth()
{
	return this->max_depth;
}

/**
 * clearSolutions
 *
 * Clear the current list of solutions.
 * This prevents muliple-counting when multiple jobs are grouped to a single process.
 */
void SolutionChecker::clearSolutions()
{
	bzero(this->num_solutions_at, this->max_depth * sizeof(int));
}

/**
 * writeSolutionData -- return a string of statistics from the solution attempts.
 */
char* SolutionChecker::writeStatisticsData()
{
	char* buffer = (char*) malloc(100);

	sprintf(buffer, "\n");

	return buffer;
}
