/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * canonstring.hpp
 *
 *  Created on: Jan 24, 2011
 *      Author: derrickstolee
 */

#ifndef CANONSTRING_HPP_
#define CANONSTRING_HPP_

#include "nausparse.h"

/**
 * getCanonString
 *
 * Output a canonical string for the given graph.
 *
 * First, it makes a deep copy of g, using the -1 markers in g->v as deleted vertices
 * 	and -1 markers in g->e as deleted edges.
 *
 * Second, it puts this deep copy into nauty and finds a canonical labeling.
 *
 * This canonical labeling is turned into a string.
 *
 * The string is copied from nauty's standard memory into the heap.
 *
 * The requestor is responsible for free()ing the returned string.
 */
char* getCanonString(sparsegraph* g);

#endif /* CANONSTRING_HPP_ */
