/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * connectivity.hpp
 *
 *  Created on: Dec 18, 2010
 *      Author: derrickstolee
 */

#ifndef CONNECTIVITY_HPP_
#define CONNECTIVITY_HPP_

#include "nausparse.h"

/**
 * is2connected
 *
 * Is the graph still 2-connected without the specified ear?
 *
 * @param g an undirected sparsegraph
 * @param v1 an index of a vertex
 * @param v2 an index of another vertex
 * @param without_ear an array of vertices, -1 terminated.
 */
bool is2connected(sparsegraph* g, int v1, int v2, char* without_ear);

#endif /* CONNECTIVITY_HPP_ */
