/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * hours.c
 *
 *  Created on: Feb 27, 2011
 *      Author: derrickstolee
 */

#include <stdio.h>

int main(void)
{
	double seconds;

	while ( scanf("%lf", &seconds) != EOF )
	{
		long long int seconds_int = seconds;

		int msecs, secs, mins, hrs, days, yrs;

		msecs = (seconds - (double) seconds_int) * 100.0;

		secs = seconds_int % 60;
		mins = (seconds_int % 3600) / 60;

		double hours = (seconds_int % (3600 * 24)) / 3600.0;
		hrs = (seconds_int % (3600 * 24)) / 3600;

		int mhrs = (hours - (double) hrs) * 100.0;
		days = (seconds_int % (3600 * 24 * 365)) / (3600 * 24);
		yrs = seconds_int / (3600 * 24 * 365);

		if ( yrs > 0 )
		{
			printf("%2dy", yrs);
		}
		printf(" & ");

		if ( days > 0 )
		{
			printf("%3dd", days);
		}
		printf(" & ");
		if ( hrs > 0 )
		{
			printf("%2d&%2dh", hrs,mhrs);
		}

		printf(" \\\\\n", secs, msecs);
	}

	return 0;
}
