/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * pairs.c
 *
 *  Created on: Oct 28, 2010
 *      Author: derrickstolee
 */

#include "pairs.h"

/*************************************/
/********TRANSLATION METHODS**********/
/*************************************/

/**
 * pairToIndex
 *
 * @param n The total number of vertices.
 * @param v1
 * @param v2
 * @return the index for edge {v1, v2}
 */
int pairToIndex(int n, int v1, int v2)
{
	if ( v1 == v2 )
	{
		return -1;
	}

	if ( v1 > v2 )
	{
		return pairToIndex(n, v2, v1);
	}

	int index = 0;

	for ( int i = 0; i < v1; i++ )
	{
		index += n - (i + 1);
	}

	index += v2 - (v1 + 1);

	return index;
}

/**
 * indexToPair
 *
 * @param n The total number of vertices.
 * @param index
 * @param v1
 * @param v2
 * @return the index for edge {v1, v2}
 */
void indexToPair(int n, int index, int& v1, int& v2)
{
	int index2 = index;
	int i;
	for ( i = 0; index2 >= n - (i + 1); i++ )
	{
		index2 = index2 - (n - (i + 1));
	}

	v1 = i;
	v2 = index2 + i + 1;
}
