/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * pairs.h
 *
 *  Created on: Oct 28, 2010
 *      Author: derrickstolee
 */

#ifndef PAIRS_H_
#define PAIRS_H_

/*************************************/
/********TRANSLATION METHODS**********/
/*************************************/

/**
 * pairToIndex
 *
 * @param n The total number of vertices.
 * @param v1
 * @param v2
 * @return the index for edge {v1, v2}
 */
int pairToIndex(int n, int v1, int v2);

/**
 * indexToPair
 *
 * @param n The total number of vertices.
 * @param index
 * @param v1
 * @param v2
 * @return the index for edge {v1, v2}
 */
void indexToPair(int n, int index, int& v1, int& v2);

#endif /* PAIRS_H_ */
