/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/

/*
 * permcount.h
 *
 *  Created on: Oct 16, 2010
 *      Author: derrickstolee
 */

#ifndef PERMCOUNT_H_
#define PERMCOUNT_H_

#include "nausparse.h"


int getConjC(int p);


/**
 * Return the number of perfect matchings in the sparsegraph g.
 *
 * It will consider vertices i with g->v[i] < 0 as "deleted" and not available (allows for recursion).
 *
 * If the number of perfect matchings exceeds max_p, returns that number, which may not be the full count.
 *
 */
int countPM(sparsegraph* g, int max_p);


/**
 * Return the number of perfect matchings in the sparsegraph g.
 *
 * It will consider vertices i with g->v[i] < 0 as "deleted" and not available (allows for recursion).
 *
 * If the number of perfect matchings exceeds max_p, returns that number, which may not be the full count.
 *
 */
int countPM(sparsegraph* g, int max_p, int* labels);



/**
 * Return true iff the sparsegraph g has a perfect matching.
 *
 * It will consider vertices i with g->v[i] < 0 as "deleted" and not available (allows for recursion). *
 */
bool hasPM(sparsegraph* g);


/**
 * hasPM -- find a perfect matching and return the labels of the edges in a list.
 *
 */
bool hasPM(sparsegraph* g, int* labels);

#endif /* PERMCOUNT_H_ */
