/***********************************************************

 Copyright Derrick Stolee 2012.

 This file is part of SearchLib.

 SearchLib is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SearchLib is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

 *************************************************************/

/*
 * mmslight-glpk.cpp
 *
 *  Created on: Dec 13, 2012
 *      Author: stolee
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "translation.hpp"
#include "MMSLightweightManager.hpp"

int main( int argc, char** argv )
{
	int n = 0;
	int k = 0;
	bool strong_mode = false;
	int target = -1;
	bool do_stochastic = false;
	bool do_branchless = false;
	int num_to_halt = 100;
	int sample_time = 3600;
	int steps = 0;

	for ( int i = 1; i < argc - 1; i++ )
	{
		if ( strcmp(argv[i], "-N") == 0 )
		{
			n = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "-K") == 0 )
		{
			k = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "--strong") == 0 )
		{
			strong_mode = true;
			if ( target == 0 )
			{
				target = nChooseK(n - 1, k - 1) + 1;
			}
		}
		if ( strcmp(argv[i], "--target") == 0 )
		{
			target = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "--samples") == 0 )
		{
			num_to_halt = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "--sampletime") == 0 )
		{
			sample_time = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "--steps") == 0 )
		{
			steps = atoi(argv[i + 1]);
		}
	}

	if ( strcmp(argv[argc - 1], "--strong") == 0 )
	{
		strong_mode = true;
		if ( target == 0 )
		{
			target = nChooseK(n - 1, k - 1) + 1;
		}
	}

	if ( n <= 0 || k <= 0 )
	{
		printf("Usage: mmsconj.exe -N # -K # --prop [none|gac|bsgac|sgac] [--strong] [TreeSearch arguments]\n");
		return 0;
	}

	initBinomialTable(2 * n, k + 1);

	MMSLightweightManager* manager = new MMSLightweightManager(n, k);

	manager->importArguments(argc, argv);
	manager->setNumSamplesToHalt(num_to_halt);
	manager->setSampleTime(sample_time);
	manager->setDistributionSteps(steps);

	for ( int i = 1; i < argc; i++ )
	{
		if ( strcmp(argv[i], "--stochastic") == 0 )
		{
			srand((unsigned) time(NULL));
			manager->useStochasticSearch(true);
			manager->setNumSamplesToHalt(num_to_halt);
//			use_right_c_star = false;
		}
		if ( strcmp(argv[i], "--branchless") == 0 )
		{
			manager->useBranchlessSearch(true);
		}
	}

	if ( target > 0 )
	{
		manager->setTarget(target);
	}
	else
	{
		manager->setTarget(nChooseK(n - 1, k - 1));
	}
	if ( strong_mode )
	{
		manager->setStrongMode(strong_mode);
	}

	for ( int i = 0; i < argc; i++ )
	{
		if ( argv[i][0] == '-' && argv[i][1] == 'g' && argv[i][2] == 'm' )
		{
			/** we have something -gm#v#*/
			int vpos = 3;
			while ( argv[i][vpos] != 0 && argv[i][vpos] != 'v' )
			{
				vpos++;
			}

			if ( argv[i][vpos] == 'v' )
			{
				// success
				argv[i][vpos] = 0;
				int mval = atoi(argv[i] + 3);
				int val = atoi(argv[i] + vpos + 1);

				manager->setGValue(mval, val);
			}
		}
	}

	while ( manager->readJob(stdin) >= 0 )
	{
		srand((unsigned) time(NULL));

		manager->clearAll();

		manager->propagate();

		/** doSearch will load a job AND run branchless/stochastic, if necessary */
		manager->doSearch();
	}

	//delete manager;

	cleanBinomialTable();

	return 0;
}

