/***********************************************************

 Copyright Derrick Stolee 2012.

 This file is part of SearchLib.

 SearchLib is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SearchLib is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

 *************************************************************/

/*
 * mmsverify-cplex.cpp
 *
 *  Created on: Dec 13, 2012
 *      Author: stolee
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "translation.hpp"
#include "MMSLightweightManager.hpp"

int main( int argc, char** argv )
{
	int n = 0;
	int k = 0;
	bool strong_mode = false;
	int target = -1;
	bool do_stochastic = false;
	bool do_branchless = false;

	for ( int i = 1; i < argc - 1; i++ )
	{
		if ( strcmp(argv[i], "-N") == 0 )
		{
			n = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "-K") == 0 )
		{
			k = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "--strong") == 0 )
		{
			strong_mode = true;
			if ( target == 0 )
			{
				target = nChooseK(n - 1, k - 1) + 1;
			}
		}
		if ( strcmp(argv[i], "--target") == 0 )
		{
			target = atoi(argv[i + 1]);
		}
	}

	if ( strcmp(argv[argc - 1], "--strong") == 0 )
	{
		strong_mode = true;
		if ( target == 0 )
		{
			target = nChooseK(n - 1, k - 1) + 1;
		}
	}

	if ( n <= 0 || k <= 0 )
	{
		printf("Usage: mmsconj.exe -N # -K # --prop [none|gac|bsgac|sgac] [--strong] [TreeSearch arguments]\n");
		return 0;
	}

	initBinomialTable(2 * n, k + 1);

	MMSLightweightManager* manager = new MMSLightweightManager(n, k);

	manager->importArguments(argc, argv);

	if ( target > 0 )
	{
		manager->setTarget(target);
	}
	else
	{
		manager->setTarget(nChooseK(n - 1, k - 1));
	}
	if ( strong_mode )
	{
		manager->setStrongMode(strong_mode);
	}

	for ( int i = 0; i < argc; i++ )
	{
		if ( argv[i][0] == '-' && argv[i][1] == 'g' && argv[i][2] == 'm' )
		{
			/** we have something -gm#v#*/
			int vpos = 3;
			while ( argv[i][vpos] != 0 && argv[i][vpos] != 'v' )
			{
				vpos++;
			}

			if ( argv[i][vpos] == 'v' )
			{
				// success
				argv[i][vpos] = 0;
				int mval = atoi(argv[i] + 3);
				int val = atoi(argv[i] + vpos + 1);

				manager->setGValue(mval, val);
			}
		}
	}

	char buffer[1024];
	int* set = (int*) malloc(k * sizeof(int));
	while ( scanf("%s", buffer) != EOF)
	{
		if ( strcmp(buffer, "XBP") == 0 )
		{
			printf("%s", buffer);
			for ( int i = 0; i < k; i++ )
			{
				scanf("%d", &(set[i]));
				printf(" %02d", set[i]);
			}
			printf(" \n");
			// branch positively
			manager->resetGenNeg();
//			manager->recalculateAllCStarValues();

			manager->branchPositiveSet(INDEX_OF_SET(n,k,set), 1);
		}
		else if ( strcmp(buffer, "XBN") == 0 )
		{
			printf("%s", buffer);
			for ( int i = 0; i < k; i++ )
			{
				scanf("%d", &(set[i]));
				printf(" %02d", set[i]);
			}
			printf(" \n");

			// branch negatively
			manager->resetGenNeg();
//			manager->recalculateAllCStarValues();

			manager->branchNegativeSet(INDEX_OF_SET(n,k,set), -1);
		}
		else if ( strcmp(buffer, "XPP") == 0 )
		{
			printf("%s", buffer);
			for ( int i = 0; i < k; i++ )
			{
				scanf("%d", &(set[i]));
				printf(" %02d", set[i]);
			}
			printf(" \n");

			// branch positively DUE TO infeasible LP!
			manager->resetGenNeg();
//			manager->recalculateAllCStarValues();
			bool result = manager->propagate();

			result = manager->isLPFeasibleWithConstraint(set, -1);

			if ( !result )
			{
				manager->branchPositiveSet(INDEX_OF_SET(n,k,set), 2);
			}
			else
			{
				printf("--FAILED, SINCE THE SET ");
				for ( int i = 0; i < k; i++ )
				{
					printf("%02d ", set[i]);
				}
				printf(" DOES NOT NEED TO BE POSITIVE!\n");
				exit(1);
			}
		}
		else if ( strcmp(buffer, "XPN") == 0 )
		{
			printf("%s", buffer);
			for ( int i = 0; i < k; i++ )
			{
				scanf("%d", &(set[i]));
				printf(" %02d", set[i]);
			}
			printf(" \n");

			// branch negatively DUE TO infeasible LP!
			manager->resetGenNeg();
//			manager->recalculateAllCStarValues();
			bool result = manager->propagate();

			result = manager->isLPFeasibleWithConstraint(set, 1);

			if ( !result )
			{
				manager->branchNegativeSet(INDEX_OF_SET(n,k,set), -2);
			}
			else
			{
				printf("--FAILED, SINCE THE SET ");
				for ( int i = 0; i < k; i++ )
				{
					printf("%02d ", set[i]);
				}
				printf(" DOES NOT NEED TO BE NEGATIVE!\n");
				exit(1);
			}
		}
		else if ( strcmp(buffer, "STOP") == 0 )
		{
			manager->resetGenNeg();
			bool result = manager->propagate();

			if ( result && manager->num_forced_positive < target )
			{
				printf("VERIFICATION FAILS: STILL SOMETHING CAN BE DONE!\n");
				manager->printStatus();
			}
			else
			{
				printf("VERIFICATION SUCCEEDS.\n");
			}

			manager->clearAll();
		}
	}

	cleanBinomialTable();

	return 0;
}

