/***********************************************************

 Copyright Derrick Stolee 2012.

 This file is part of SearchLib.

 SearchLib is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SearchLib is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

 *************************************************************/

/*
 * test-leftshift.cpp
 *
 *  Created on: Dec 7, 2012
 *      Author: stolee
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "translation.hpp"
#include "MMSBranchingManager.hpp"
#include "MMSLightweightManager.hpp"

//#define TEST_AROUND(OPERATION,MSG) start_time = time(NULL); OPERATION; end_time = time(NULL); printf("%s took %4ld seconds\n", MSG, end_time-start_time);
#define TEST_AROUND(OPERATION,MSG) start_clock = clock(); OPERATION; end_clock = clock(); printf("%s took %4.6lf seconds\n", MSG, ((double)(end_clock - start_clock)) / (double) CLOCKS_PER_SEC);

int main( int argc, char** argv )
{
	int n = 0;
	int k = 0;
	char prop_mode = PROPAGATE_GAC;
	bool strong_mode = false;
	bool prop_pos = false;
	bool write_proof = false;
	char branch_rule = BRANCH_LEFTHALF;
	int target = 0;
	bool use_right_shift = false;

	for ( int i = 1; i < argc - 1; i++ )
	{
		if ( strcmp(argv[i], "-N") == 0 )
		{
			n = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "-K") == 0 )
		{
			k = atoi(argv[i + 1]);
		}
		if ( strcmp(argv[i], "--strong") == 0 )
		{
			strong_mode = true;
			if ( target == 0 )
			{
				target = nChooseK(n - 1, k - 1) + 1;
			}
		}
		if ( strcmp(argv[i], "--prop") == 0 )
		{
			if ( strcmp(argv[i + 1], "none") == 0 )
			{
				prop_mode = PROPAGATE_NONE;
			}
			else if ( strcmp(argv[i + 1], "gac") == 0 )
			{
				prop_mode = PROPAGATE_GAC;
			}
			else if ( strcmp(argv[i + 1], "bsgac") == 0 )
			{
				prop_mode = PROPAGATE_BRANCH_SGAC;
			}
			else if ( strcmp(argv[i + 1], "sgac") == 0 )
			{
				prop_mode = PROPAGATE_SGAC;
			}
			else if ( strcmp(argv[i + 1], "pos") == 0 )
			{
				prop_pos = true;
			}
		}
		if ( strcmp(argv[i], "--proof") == 0 )
		{
			write_proof = true;
		}
		if ( strcmp(argv[i], "--rule") == 0 )
		{
			if ( strcmp(argv[i + 1], "middle") == 0 )
			{
				branch_rule = BRANCH_MIDDLE;
			}
			else if ( strcmp(argv[i + 1], "balanced") == 0 )
			{
				branch_rule = BRANCH_BALANCED;
			}
			else if ( strcmp(argv[i + 1], "opthalf") == 0 )
			{
				branch_rule = BRANCH_OPTHALF;
			}
			else if ( strcmp(argv[i + 1], "lefthalf") == 0 )
			{
				branch_rule = BRANCH_LEFTHALF;
			}
		}
		if ( strcmp(argv[i], "--target") == 0 )
		{
			target = atoi(argv[i + 1]);
		}
	}

	if ( strcmp(argv[argc - 1], "--proof") == 0 )
	{
		write_proof = true;
	}
	if ( strcmp(argv[argc - 1], "--strong") == 0 )
	{
		strong_mode = true;
		if ( target == 0 )
		{
			target = nChooseK(n - 1, k - 1) + 1;
		}
	}

	if ( n <= 0 || k <= 0 )
	{
		printf("Usage: mmsconj.exe -N # -K # --prop [none|gac|bsgac|sgac] [--strong] [TreeSearch arguments]\n");
		return 0;
	}

	initBinomialTable(n, k);

	bool use_bfs = false;

	MMSBranchingManager* manager_bfs = new MMSBranchingManager(n, k, write_proof);
	MMSBranchingManager* manager_inex = new MMSBranchingManager(n, k, write_proof);
	MMSBranchingManager* manager_lex = new MMSBranchingManager(n, k, write_proof);

	MMSLightweightManager* lwmangaer_inex = new MMSLightweightManager(n, k);

	MMSBranchingManager* manager = manager_bfs;

	manager->disableLP();
	manager->useRightCStar(use_right_shift);
	manager->importArguments(argc, argv);
	manager->setPropagationMode(prop_mode);
	manager->setPropagationPositive(prop_pos);
	manager->setBranchingRule(branch_rule);

	if ( target > 0 )
	{
		manager->setTarget(target);
	}
	if ( strong_mode )
	{
		manager->setStrongMode(strong_mode);
	}

	manager = manager_inex;

	manager->disableLP();
	manager->useRightCStar(use_right_shift);
	manager->importArguments(argc, argv);
	manager->setPropagationMode(prop_mode);
	manager->setPropagationPositive(prop_pos);
	manager->setBranchingRule(branch_rule);

	if ( target > 0 )
	{
		manager->setTarget(target);
	}
	if ( strong_mode )
	{
		manager->setStrongMode(strong_mode);
	}

	manager = manager_lex;

	manager->disableLP();
	manager->useRightCStar(use_right_shift);
	manager->importArguments(argc, argv);
	manager->setPropagationMode(prop_mode);
	manager->setPropagationPositive(prop_pos);
	manager->setBranchingRule(branch_rule);

	if ( target > 0 )
	{
		manager->setTarget(target);
	}
	if ( strong_mode )
	{
		manager->setStrongMode(strong_mode);
	}

	lwmangaer_inex->importArguments(argc, argv);

	if ( target > 0 )
	{
		lwmangaer_inex->setTarget(target);
	}
	if ( strong_mode )
	{
		lwmangaer_inex->setStrongMode(strong_mode);
	}

	time_t start_time = 0;
	time_t end_time = 0;
	clock_t start_clock = 0;
	clock_t end_clock = 0;
	int count = 0;

	int* set = (int*) malloc(k * sizeof(int));
	int* neighbors = (int*) malloc(k * sizeof(int));
	int* nset1 = (int*) malloc(k * sizeof(int));
	int* nset2 = (int*) malloc(k * sizeof(int));

	manager_bfs->useBFSLeft();
	manager_inex->useInclusionExclusionLeft();
	manager_lex->useIncrementalMethodLeft();

	for ( int i = 0; i < manager_inex->nchoosek; i++ )
	{
		lexIndexToSet(n, k, i, set);
		int colex_i = indexOfSet(k, set);
		int lw_leftdegree = lwmangaer_inex->getLeftNeighborRanks(set, neighbors);
		int inex_leftdegree = manager_inex->left_degree[i];

		if ( lw_leftdegree != inex_leftdegree )
		{
			printf("LEFT DEGREES ON SET ");
			for ( int j = 0; j < k; j++ )
			{
				printf("%2d ", set[j]);
			}
			printf(" INEX %2d LIGHT %2d\n", lw_leftdegree, inex_leftdegree);
		}
		else
		{
			for ( int j = 0; j < lw_leftdegree; j++ )
			{
				int lex_n = manager_inex->left_neighbors[k * i + j];
				int colex_n = neighbors[j];

				lexIndexToSet(n, k, lex_n, nset1);
				indexToSet(k, colex_n, nset2);

				if ( indexOfSet(k, nset1) != colex_n )
				{
					printf("LEFT NEIGHBOR %d of %5d wrong: ", j, i);
					for ( int l = 0; l < k; l++ )
					{
						printf("%2d ", nset1[l]);
					}
					printf(" VERSUS ");
					for ( int l = 0; l < k; l++ )
					{
						printf("%2d ", nset2[l]);
					}
					printf("\n");
				}
			}
		}

		int lw_rightdegree = lwmangaer_inex->getRightNeighborRanks(set, neighbors);
		int inex_rightdegree = manager_inex->right_degree[i];
		if ( lw_rightdegree != inex_rightdegree )
		{
			printf("RIGHT DEGREES ON SET ");
			for ( int j = 0; j < k; j++ )
			{
				printf("%2d ", set[j]);
			}
			printf(" INEX %2d LIGHT %2d\n", inex_rightdegree, lw_rightdegree);
		}
		else
		{
			for ( int j = 0; j < lw_rightdegree; j++ )
			{
				int lex_n = manager_inex->right_neighbors[k * i + j];
				int colex_n = neighbors[j];

				lexIndexToSet(n, k, lex_n, nset1);
				indexToSet(k, colex_n, nset2);

				if ( indexOfSet(k, nset1) != colex_n )
				{
					printf("RIGHT NEIGHBOR %d of %5d wrong: ", j, i);
					for ( int l = 0; l < k; l++ )
					{
						printf("%2d ", nset1[l]);
					}
					printf(" VERSUS ");
					for ( int l = 0; l < k; l++ )
					{
						printf("%2d ", nset2[l]);
					}
					printf("\n");
				}
			}
		}
	}

	/* NOW We make choices and test lstar values! */

	/* TEST */
	if ( (use_bfs && manager_bfs->testAgainst(manager_inex, manager_lex) == false)
	        || (manager_inex->testAgainst(manager_lex, manager_lex) == false) )
	{
		count++;
		printf("FAIL AT %d.\n", count);
		exit(1);
	}

	if ( use_bfs )
	{
		TEST_AROUND(manager_bfs->propagate(), "BFS propagate");
	}
	TEST_AROUND(manager_inex->propagate(), "INEX propagate");
	TEST_AROUND(manager_lex->propagate(), "LEX propagate");
	TEST_AROUND(lwmangaer_inex->propagate(), "LIGHT propagate");
	printf("\n");

	/* TEST */
	if ( (use_bfs && manager_bfs->testAgainst(manager_inex, manager_lex) == false)
	        || (manager_inex->testAgainst(manager_lex, manager_lex) == false) )
	{
		count++;
		printf("FAIL AT %d.\n", count);
		fflush(stdout);
		exit(1);
	}

	int branch;
	int* bset = (int*) malloc(k * sizeof(int));

	srand((unsigned) time(NULL));

	for ( int i = 0; i < 100; i++ )
	{
		lwmangaer_inex->resetGenNeg();
		branch = manager_inex->getRandomSetInCStar();

		if ( branch < 0 )
		{
			return 0;
		}

		lexIndexToSet(n, k, branch, bset);
		printf("----- Branching on ");
		for ( int j = 0; j < k; j++ )
		{
			printf("%2d ", bset[j]);
		}
		printf("\n");

		if ( use_bfs )
		{
			TEST_AROUND(manager_bfs->branchPositiveSet(branch), "BFS branch");
		}

		TEST_AROUND(manager_inex->branchPositiveSet(branch), "INEX branch");
		TEST_AROUND(manager_lex->branchPositiveSet(branch), " LEX branch");
		TEST_AROUND(lwmangaer_inex->branchPositiveSet(indexOfSet(k,bset), 1), " LIGHT branch");
		printf("\n");

//		manager_inex->recalculateAllCStarValues(0);
//		manager_lex->recalculateAllCStarValues(0);
//		lwmangaer_inex->recalculateAllCStarValues();

		/* TEST */
		if ( (use_bfs && manager_bfs->testAgainst(manager_inex, manager_lex) == false)
		        || (manager_inex->testAgainst(manager_lex, manager_lex) == false) )
		{
			count++;
			printf("FAIL AT %d.\n", count);
			fflush(stdout);
			exit(1);
		}

		/* TEST INEX VS LIGHT */
		lexIndexToSet(n, k, 0, bset);
		for ( int i = 0; i < manager_inex->nchoosek; i++ )
		{
			int colex_i = indexOfSet(k, bset);
			if ( manager_inex->set_labels[i] == LABEL_C_STAR )
			{
				if ( manager_inex->left_c_star[i] != lwmangaer_inex->left_c_star[colex_i] )
				{
					printf("LEFT_C_STAR ");
					for ( int j = 0; j < k; j++ )
					{
						printf("%2d ", bset[j]);
					}
					printf("   INEX: %10d     LIGHT: %10d\n", manager_inex->left_c_star[i],
					       lwmangaer_inex->left_c_star[colex_i]);
				}
			}

			getLexSuccessor(n, k, bset);
		}
		printf("\n");

		lwmangaer_inex->resetGenNeg();

		printf("----- PROPAGATING!\n", branch);
		if ( use_bfs )
		{
			TEST_AROUND(manager_bfs->propagate(), "BFS propagate");
		}
		TEST_AROUND(manager_inex->propagate(), "INEX propagate");
		TEST_AROUND(manager_lex->propagate(), "LEX propagate");
		TEST_AROUND(lwmangaer_inex->propagate(), "LIGHT propagate");
		printf("\n");

//		manager_inex->recalculateAllCStarValues(0);
//		manager_lex->recalculateAllCStarValues(0);
//		lwmangaer_inex->recalculateAllCStarValues();

		/* TEST */
		if ( (use_bfs && manager_bfs->testAgainst(manager_inex, manager_lex) == false)
		        || (manager_inex->testAgainst(manager_lex, manager_lex) == false) )
		{
			count++;
			printf("FAIL AT %d.\n", count);
			fflush(stdout);
			exit(1);
		}

		/* TEST INEX VS LIGHT */
		lexIndexToSet(n, k, 0, bset);
		for ( int i = 0; i < manager_inex->nchoosek; i++ )
		{
			int colex_i = indexOfSet(k, bset);

			if ( manager_inex->set_labels[i] != lwmangaer_inex->set_labels[colex_i] )
			{
				printf("SET_LABELS ");
				for ( int j = 0; j < k; j++ )
				{
					printf("%2d ", bset[j]);
				}
				printf("   INEX: %d     LIGHT: %d\n", manager_inex->set_labels[i], lwmangaer_inex->set_labels[colex_i]);
			}
			else if ( manager_inex->set_labels[i] == LABEL_C_STAR )
			{
				if ( manager_inex->left_c_star[i] != lwmangaer_inex->left_c_star[colex_i] )
				{
					printf("LEFT_C_STAR ");
					for ( int j = 0; j < k; j++ )
					{
						printf("%2d ", bset[j]);
					}
					printf("   INEX: %10d     LIGHT: %10d\n", manager_inex->left_c_star[i],
					       lwmangaer_inex->left_c_star[colex_i]);
				}
			}

			getLexSuccessor(n, k, bset);
		}
		printf("\n");

	}

	delete manager_bfs;
	delete manager_inex;
	delete manager_lex;

	cleanBinomialTable();

	return 0;
}

