/*
 * ProgressionConstraint.cpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "ProgressionConstraint.hpp"
#include "TreeSet.hpp"

/**
 * Constructor
 */
ProgressionConstraint::ProgressionConstraint()
{
	this->positions = new TreeSet();
}

/**
 * Destructor
 */
ProgressionConstraint::~ProgressionConstraint()
{
	delete this->positions;
}

/**
 * doAllPropagation
 *
 * Perform all propagation for this rule until none are to be made.
 *
 * Performed in order of priority.
 */
bool ProgressionConstraint::doAllPropagation()
{
	bool result = true;
	while ( result && this->positions->size() > 0 )
	{
		int next = 0;

		if ( this->increasing_order )
		{
			next = this->positions->min();
		}
		else
		{
			next = this->positions->max();
		}

		this->positions->remove(next);

		result = this->doPropagation(next);
	}

	return result;
}

/**
 * addUpdatedColor
 *
 * Add a position that has had color change.
 *
 * Default: all are added.
 * Can be overridden for other rules to ignore certain places.
 */
void ProgressionConstraint::addUpdatedColor(int pos)
{
	this->positions->add(pos);
}

/**
 * addUpdatedForwardTable
 *
 * Add a position that has had a forward table change.
 *
 * Default: all are added.
 * Can be overridden for other rules to ignore certain places.
 */
void ProgressionConstraint::addUpdatedForwardTable(int pos)
{
	if ( this->positions->contains(pos) == 0 )
	{
		this->positions->add(pos);
	}
}

/**
 * addUpdatedBackwardTable
 *
 * Add a position that has had a backward table change.
 *
 * Default: all are added.
 * Can be overridden for other rules to ignore certain places.
 */
void ProgressionConstraint::addUpdatedBackwardTable(int pos)
{
	if ( this->positions->contains(pos) == 0 )
	{
		this->positions->add(pos);
	}
}

/**
 * empty -- Empty the heap. Usually associated with a rollback() call.
 */
void ProgressionConstraint::empty()
{
	this->positions->clear();
}

/**
 * isEmpty
 */
bool ProgressionConstraint::isEmpty()
{
	return (this->positions->size() <= 0);
}
