/*
 * ProgressionConstraint.hpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#ifndef PROGRESSIONCONSTRAINT_HPP_
#define PROGRESSIONCONSTRAINT_HPP_

#include "Set.hpp"

class ProgressionConstraint
{
protected:
	/**
	 * increasing_order is TRUE if and only if we evaluate the positions in increasing order.
	 * This affects what sorting is used in the heap.
	 */
	bool increasing_order;

	/**
	 * positions -- the array storage for the heap.
	 */
	Set* positions;

public:
	/**
	 * Constructor
	 */
	ProgressionConstraint();

	/**
	 * Destructor
	 */
	virtual ~ProgressionConstraint();

	/**
	 * doPropagation
	 *
	 * Abstract method to perform whatever rule should be checked at the given position.
	 */
	virtual bool doPropagation(int pos) = 0;

	/**
	 * doAllPropagation
	 *
	 * Perform all propagation for this rule until none are to be made.
	 *
	 * Performed in order of priority.
	 */
	bool doAllPropagation();

	/**
	 * addUpdatedColor
	 *
	 * Add a position that has had color change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedColor(int pos);

	/**
	 * addUpdatedForwardTable
	 *
	 * Add a position that has had a forward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedForwardTable(int pos);

	/**
	 * addUpdatedBackwardTable
	 *
	 * Add a position that has had a backward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedBackwardTable(int pos);

	/**
	 * empty -- Empty the heap. Usually associated with a rollback() call.
	 */
	void empty();

	/**
	 * isEmpty
	 */
	bool isEmpty();
};

#endif /* PROGRESSIONCONSTRAINT_HPP_ */
