/*
 * PseudoBDomainConstraint.hpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#ifndef PSEUDOBDOMAINCONSTRAINT_HPP_
#define PSEUDOBDOMAINCONSTRAINT_HPP_


#include "ProgressionTable.hpp"
#include "ProgressionConstraint.hpp"

class PseudoBDomainConstraint : public ProgressionConstraint
{
protected:
	ProgressionTable* table;


public:
	/**
	 * Constructor
	 */
	PseudoBDomainConstraint(ProgressionTable* table);

	/**
	 * Destructor
	 */
	virtual ~PseudoBDomainConstraint();

	/**
	 * doPropagation
	 *
	 * Abstract method to perform whatever rule should be checked at the given position.
	 */
	bool doPropagation(int pos);


	/**
	 * addUpdatedForwardTable
	 *
	 * Add a position that has had a forward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedForwardTable(int pos);
};


#endif /* PSEUDOBDOMAINCONSTRAINT_HPP_ */
