/*
 * PseudoBackwardConstraint.cpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#include "ProgressionTable.hpp"
#include "PseudoBackwardConstraint.hpp"

/**
 * Constructor
 */
PseudoBackwardConstraint::PseudoBackwardConstraint(ProgressionTable* table)
{
	this->table = table;
	this->increasing_order = true;
}

/**
 * Destructor
 */
PseudoBackwardConstraint::~PseudoBackwardConstraint()
{

}

/**
 * doPropagation
 *
 * Abstract method to perform whatever rule should be checked at the given position.
 */
bool PseudoBackwardConstraint::doPropagation(int pos)
{
	/* PAP Backward Propagation Rule. */
	if ( pos < -this->table->getMinSolN() )
	{
		/* do not extend the backward table beyond this position */
		return true;
	}

	char c = this->table->getColor(pos);
	bool result = true;

	if ( c != UNKNOWN )
	{
		for ( int l = 0; result && l < this->table->getMaxL(); l++ )
		{
			for ( int dp = 0; result && dp <= this->table->getD(); dp++ )
			{
				int val = this->table->getBackwardTable(c, pos, l, dp);

				if ( val >= this->table->getK() - 1 )
				{
					result = false;
					break;
				}
				else
				{
					for ( int d = 0; result && d <= this->table->getD() - dp; d++ )
					{
						result = this->table->setBackwardTable(c, pos + (l + 1 + d), l, d + dp, val + 1);
					}
				}
			}
		}
	}

	return result || !(this->table->isInKillRange(pos));
}

/**
 * addUpdatedForwardTable
 *
 * Add a position that has had a forward table change.
 *
 * Default: all are added.
 * Can be overridden for other rules to ignore certain places.
 */
void PseudoBackwardConstraint::addUpdatedForwardTable(int pos)
{

}

