/*
 * PseudoBackwardConstraint.hpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#ifndef PSEUDOBACKWARDCONSTRAINT_HPP_
#define PSEUDOBACKWARDCONSTRAINT_HPP_


#include "ProgressionTable.hpp"
#include "ProgressionConstraint.hpp"

class PseudoBackwardConstraint: public ProgressionConstraint
{
protected:
	ProgressionTable* table;


public:
	/**
	 * Constructor
	 */
	PseudoBackwardConstraint(ProgressionTable* table);

	/**
	 * Destructor
	 */
	virtual ~PseudoBackwardConstraint();

	/**
	 * doPropagation
	 *
	 * Abstract method to perform whatever rule should be checked at the given position.
	 */
	bool doPropagation(int pos);


	/**
	 * addUpdatedForwardTable
	 *
	 * Add a position that has had a forward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedForwardTable(int pos);

};


#endif /* PSEUDOBACKWARDCONSTRAINT_HPP_ */
