/*
 * PseudoFBDomainConstraint.cpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#include "PseudoFBDomainConstraint.hpp"

/**
 * Constructor
 */
PseudoFBDomainConstraint::PseudoFBDomainConstraint(ProgressionTable* table)
{
	this->table = table;
	this->increasing_order = true;
}

/**
 * Destructor
 */
PseudoFBDomainConstraint::~PseudoFBDomainConstraint()
{

}

/**
 * doPropagation
 *
 * Abstract method to perform whatever rule should be checked at the given position.
 */
bool PseudoFBDomainConstraint::doPropagation(int pos)
{
	/* PAP Forward/Backward Domain Update Rule. */
	bool result = true;

	for ( char c = 0; result && c < this->table->getNumColors(); c++ )
	{
		for ( int l = 0; result && l < this->table->getMaxL(); l++ )
		{
			for ( int d = 0; result && d <= this->table->getD(); d++ )
			{
				int fval = this->table->getForwardTable(c, pos, l, d);
				int bval = this->table->getBackwardTable(c, pos, l, this->table->getD() - d);

				if ( fval + bval >= this->table->getK() - 1 )
				{
					result = this->table->removeColorFromDomain(pos, c) && result;
				}
			}
		}
	}

	return result || !(this->table->isInKillRange(pos));
}

