/*
 * PseudoForwardConstraint.cpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#include "PseudoForwardConstraint.hpp"

/**
 * Constructor
 */
PseudoForwardConstraint::PseudoForwardConstraint(ProgressionTable* table)
{
	this->table = table;
	this->increasing_order = false; /* reverse! max first! */
}

/**
 * Destructor
 */
PseudoForwardConstraint::~PseudoForwardConstraint()
{
	this->table = 0;
}

/**
 * doPropagation
 *
 * Abstract method to perform whatever rule should be checked at the given position.
 */
bool PseudoForwardConstraint::doPropagation(int pos)
{
	/* PAP Forward Propagation Rule. */
	if ( pos >= this->table->getMinSolN() )
	{
		/* do not extend the forward table beyond this position */
		return true;
	}

	char c = this->table->getColor(pos);
	bool result = true;

	if ( c != UNKNOWN )
	{
		for ( int l = 0; result && l < this->table->getMaxL(); l++ )
		{
			for ( int dp = 0; result && dp <= this->table->getD(); dp++ )
			{
				int val = this->table->getForwardTable(c, pos, l, dp);

				if ( val >= this->table->getK() - 1 )
				{
					result = false;
					break;
				}
				else
				{
					for ( int d = 0; result && d <= this->table->getD() - dp; d++ )
					{
						int new_pos = pos - (l + 1 + d);
						bool temp_result = this->table->setForwardTable(c, new_pos, l, d + dp, val + 1);

						/* should we care about this change? */
						result = temp_result || !(this->table->isInKillRange(new_pos));
					}
				}
			}
		}
	}

	return result || !(this->table->isInKillRange(pos));
}

/**
 * addUpdatedForwardTable
 *
 * Add a position that has had a forward table change.
 *
 * Default: all are added.
 * Can be overridden for other rules to ignore certain places.
 */
void PseudoForwardConstraint::addUpdatedBackwardTable(int pos)
{
	/* do nothing, we don't care. */
}

