/*
 * PseudoForwardConstraint.hpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#ifndef PSEUDOFORWARDCONSTRAINT_HPP_
#define PSEUDOFORWARDCONSTRAINT_HPP_

#include "ProgressionConstraint.hpp"
#include "ProgressionTable.hpp"

class PseudoForwardConstraint: public ProgressionConstraint
{
protected:
	ProgressionTable* table;

public:
	/**
	 * Constructor
	 */
	PseudoForwardConstraint(ProgressionTable* table);

	/**
	 * Destructor
	 */
	virtual ~PseudoForwardConstraint();

	/**
	 * doPropagation
	 *
	 * Abstract method to perform whatever rule should be checked at the given position.
	 */
	bool doPropagation(int pos);

	/**
	 * addUpdatedForwardTable
	 *
	 * Add a position that has had a forward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedBackwardTable(int pos);

};

#endif /* PSEUDOFORWARDCONSTRAINT_HPP_ */
