/*
 * QuasiBDomainConstraint.cpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#include "QuasiBDomainConstraint.hpp"

/**
 * Constructor
 */
QuasiBDomainConstraint::QuasiBDomainConstraint(ProgressionTable* table)
{
	this->table = table;
	this->increasing_order = true;
}

/**
 * Destructor
 */
QuasiBDomainConstraint::~QuasiBDomainConstraint()
{

}

/**
 * doPropagation
 *
 * Abstract method to perform whatever rule should be checked at the given position.
 */
bool QuasiBDomainConstraint::doPropagation(int pos)
{
	/* QAP Backward Domain Update Rule. */
	bool result = true;

	for ( char c = 0; result && c < this->table->getNumColors(); c++ )
	{
		for ( int l = 0; result && l < this->table->getMaxL(); l++ )
		{
			int val = this->table->getBackwardTable(c, pos, l);

			if ( val >= this->table->getK() - 1 )
			{
				result = this->table->removeColorFromDomain(pos, c) && result;
			}
		}
	}

	return result || !(this->table->isInKillRange(pos));
}

/**
 * addUpdatedForwardTable
 *
 * Add a position that has had a forward table change.
 *
 * Default: all are added.
 * Can be overridden for other rules to ignore certain places.
 */
void QuasiBDomainConstraint::addUpdatedForwardTable(int pos)
{
	/* do nothing */
}

