/*
 * QuasiBDomainConstraint.hpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#ifndef QUASIBDOMAINCONSTRAINT_HPP_
#define QUASIBDOMAINCONSTRAINT_HPP_

#include "ProgressionTable.hpp"
#include "ProgressionConstraint.hpp"

class QuasiBDomainConstraint : public ProgressionConstraint
{
protected:
	ProgressionTable* table;

public:
	/**
	 * Constructor
	 */
	QuasiBDomainConstraint(ProgressionTable* table);

	/**
	 * Destructor
	 */
	virtual ~QuasiBDomainConstraint();

	/**
	 * doPropagation
	 *
	 * Abstract method to perform whatever rule should be checked at the given position.
	 */
	bool doPropagation(int pos);


	/**
	 * addUpdatedForwardTable
	 *
	 * Add a position that has had a forward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedForwardTable(int pos);
};


#endif /* QUASIBDOMAINCONSTRAINT_HPP_ */
