/*
 * QuasiBackwardConstraint.cpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#include "QuasiBackwardConstraint.hpp"

/**
 * Constructor
 */
QuasiBackwardConstraint::QuasiBackwardConstraint(ProgressionTable* table)
{
	this->table = table;
	this->increasing_order = true;
}

/**
 * Destructor
 */
QuasiBackwardConstraint::~QuasiBackwardConstraint()
{

}

/**
 * doPropagation
 *
 * Abstract method to perform whatever rule should be checked at the given position.
 */
bool QuasiBackwardConstraint::doPropagation(int pos)
{
	/* QAP Backward Propagation Rule. */
	if ( pos < -this->table->getMinSolN() )
	{
		/* do not extend the backward table beyond this position */
		return true;
	}

	char c = this->table->getColor(pos);
	bool result = true;

	if ( c != UNKNOWN )
	{
		for ( int l = 0; result && l < this->table->getMaxL(); l++ )
		{
			int val = this->table->getBackwardTable(c, pos, l);

			if ( val >= this->table->getK() - 1 )
			{
				result = false;
				break;
			}
			else
			{
				for ( int d = 0; result && d <= this->table->getD(); d++ )
				{
					int new_pos = pos + (l + 1 + d);
					bool temp_result = this->table->setBackwardTable(c, new_pos, l, val + 1);

					/* should we care about this change? */
					result = temp_result || !(this->table->isInKillRange(new_pos));
				}
			}
		}
	}

	return result || !(this->table->isInKillRange(pos));
}

/**
 * addUpdatedForwardTable
 *
 * Add a position that has had a forward table change.
 *
 * Default: all are added.
 * Can be overridden for other rules to ignore certain places.
 */
void QuasiBackwardConstraint::addUpdatedForwardTable(int pos)
{

}

