/*
 * QuasiBackwardConstraint.hpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#ifndef QUASIBACKWARDCONSTRAINT_HPP_
#define QUASIBACKWARDCONSTRAINT_HPP_

#include "ProgressionTable.hpp"
#include "ProgressionConstraint.hpp"

class QuasiBackwardConstraint: public ProgressionConstraint
{
protected:
	ProgressionTable* table;

public:
	/**
	 * Constructor
	 */
	QuasiBackwardConstraint(ProgressionTable* table);

	/**
	 * Destructor
	 */
	virtual ~QuasiBackwardConstraint();

	/**
	 * doPropagation
	 *
	 * Abstract method to perform whatever rule should be checked at the given position.
	 */
	bool doPropagation(int pos);


	/**
	 * addUpdatedForwardTable
	 *
	 * Add a position that has had a forward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedForwardTable(int pos);

};

#endif /* QUASIBACKWARDCONSTRAINT_HPP_ */
