/*
 * QuasiFBDomainConstraint.cpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#include "QuasiFBDomainConstraint.hpp"

/**
 * Constructor
 */
QuasiFBDomainConstraint::QuasiFBDomainConstraint(ProgressionTable* table)
{
	this->table = table;
	this->increasing_order = true;
}

/**
 * Destructor
 */
QuasiFBDomainConstraint::~QuasiFBDomainConstraint()
{
	this->table = 0;
}

/**
 * doPropagation
 *
 * Abstract method to perform whatever rule should be checked at the given position.
 */
bool QuasiFBDomainConstraint::doPropagation(int pos)
{
	/* QAP Forward/Backward Domain Update Rule. */
	bool result = true;

	for ( char c = 0; result && c < this->table->getNumColors(); c++ )
	{
		for ( int l = 0; result && l < this->table->getMaxL(); l++ )
		{
			int fval = this->table->getForwardTable(c, pos, l);
			int bval = this->table->getBackwardTable(c, pos, l);

			if ( fval + bval >= this->table->getK() - 1 )
			{
				result = this->table->removeColorFromDomain(pos, c) && result;
			}
		}
	}

	return result || !(this->table->isInKillRange(pos));
}

