/*
 * QuasiForwardConstraint.hpp
 *
 *  Created on: Jul 29, 2011
 *      Author: dstolee
 */

#ifndef QUASIFORWARDCONSTRAINT_HPP_
#define QUASIFORWARDCONSTRAINT_HPP_

#include "ProgressionTable.hpp"
#include "ProgressionConstraint.hpp"

class QuasiForwardConstraint : public ProgressionConstraint
{
protected:
	ProgressionTable* table;


public:
	/**
	 * Constructor
	 */
	QuasiForwardConstraint(ProgressionTable* table);

	/**
	 * Destructor
	 */
	virtual ~QuasiForwardConstraint();

	/**
	 * doPropagation
	 *
	 * Abstract method to perform whatever rule should be checked at the given position.
	 */
	bool doPropagation(int pos);


	/**
	 * addUpdatedForwardTable
	 *
	 * Add a position that has had a forward table change.
	 *
	 * Default: all are added.
	 * Can be overridden for other rules to ignore certain places.
	 */
	virtual void addUpdatedBackwardTable(int pos);

};

#endif /* QUASIFORWARDCONSTRAINT_HPP_ */
