/***********************************************************

 Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

 SearchLib is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 SearchLib is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

 *************************************************************/

/*
 * avoidtest.cpp
 *
 * The avoidtest.exe executable reads a coloring in block form and checks if it avoids the type of sequences given.
 *
 *  Created on: Nov 4, 2011
 *      Author: dstolee
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "ProgressionTable.hpp"

int main(int argc, char** argv)
{
	progression_mode mode = QUASI_PROGRESSION;
	int k = 0, d = 0, minN = 0, maxN = 0;
	int r = 2;

	for ( int i = 1; i < argc; i++ )
	{
		if ( argv[i][0] == '-' && i < argc - 1 )
		{
			switch ( argv[i][1] )
			{
			case 'K':
				k = atoi(argv[i + 1]);
				break;

			case 'D':
				d = atoi(argv[i + 1]);
				break;

			case 'I':
				d = k - atoi(argv[i + 1]);
				break;

			case 'n':
				minN = atoi(argv[i + 1]);
				break;

			case 'N':
				maxN = atoi(argv[i + 1]);
				break;

			case 'R':
				r = atoi(argv[i + 1]);
				break;

			case '-':
				if ( strcmp(argv[i], "--mode") == 0 )
				{
					if ( strcmp(argv[i + 1], "quasi") == 0 )
					{
						mode = QUASI_PROGRESSION;
					}
					else if ( strcmp(argv[i + 1], "pseudo") == 0 )
					{
						mode = PSEUDO_PROGRESSION;
					}
				}
			}
		}
	}

	if ( mode == QUASI_PROGRESSION )
	{
		printf("Checking for (%d,%d)-QAPs.\n", k, d);
	}
	else
	{
		printf("Checking for (%d,%d)-PAPs.\n", k, d);
	}

	ProgressionTable* table = new ProgressionTable(mode, k, d, minN, maxN, r, NO_SYMMETRY, NO_PROPAGATION);

	int color = 0;
	int block_size = 0;

	bool swap = false;
	char initial_color = 0;

	int pos = 0;

	bool result = true;

	while ( result && scanf("%d^{%d}", &color, &block_size) != EOF )
	{
		if ( pos == 0 && color != 0 )
		{
			swap = true;
			initial_color = color;
		}

		if ( color < 0 || color >= r || block_size <= 0 )
		{
			if ( result )
			{
				if ( mode == QUASI_PROGRESSION )
				{
					printf("Coloring of {%d} Avoids (%d,%d)-QAPs.\n", pos, k, d);
				}
				else
				{
					printf("Coloring of {%d} Avoids (%d,%d)-PAPs.\n", pos, k, d);
				}
			}
			table->reset();
			pos = 0;
		}
		else
		{
			char c = color;

			if ( swap )
			{
				c = (c + r - initial_color) % r;
			}

			//printf("-- %d : %d^{%d}\n", pos, color, block_size);

			for ( int i = 0; result && i < block_size; i++ )
			{
				result = table->setColor(pos, c, true);

				result = result && !(table->hasProgression());

				if ( !result )
				{
					printf("Fails at position %d.\n", pos);
					table->print();
				}

				pos++;
			}
		}
	}

	return 0;
}

