/***********************************************************

Copyright Derrick Stolee 2011.

 This file is part of SearchLib.

    SearchLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SearchLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SearchLib.  If not, see <http://www.gnu.org/licenses/>.

*************************************************************/
/*
 * progressions.cpp
 *
 *  Created on: May 15, 2011
 *      Author: derrickstolee
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ProgressionManager.hpp"

int main(int argc, char** argv)
{
	ProgressionManager* manager = 0;

	bool FORWARD_MODE = false;
	bool BACKWARD_MODE = false;
	symmetry_mode sym_mode = NO_SYMMETRY;
	propagation_mode prop_mode = NO_PROPAGATION;

	progression_mode mode = QUASI_PROGRESSION;
	int k = 0, d = 0, minN = 0, maxN = 0;
	int r = 2;

	for ( int i = 1; i < argc; i++ )
	{
		if ( argv[i][0] == '-' && i < argc - 1 )
		{
			switch ( argv[i][1] )
			{
			case 'K':
				k = atoi(argv[i + 1]);
				break;

			case 'D':
				d = atoi(argv[i + 1]);
				break;

			case 'I':
				d = k - atoi(argv[i + 1]);
				break;

			case 'n':
				minN = atoi(argv[i + 1]);
				break;

			case 'N':
				maxN = atoi(argv[i + 1]);
				break;

			case 'R':
				r = atoi(argv[i + 1]);
				break;

			case '-':
				if ( strcmp(argv[i], "--mode") == 0 )
				{
					if ( strcmp(argv[i + 1], "quasi") == 0 )
					{
						mode = QUASI_PROGRESSION;
					}
					else if ( strcmp(argv[i + 1], "pseudo") == 0 )
					{
						mode = PSEUDO_PROGRESSION;
					}
				}
				else if ( strcmp(argv[i], "--forward") == 0 )
				{
					if ( strcmp(argv[i + 1], "on") == 0 )
					{
						FORWARD_MODE = true;
						prop_mode = FORWARD_BACKWARD_PROPAGATION;
					}
				}
				else if ( strcmp(argv[i], "--backward") == 0 )
				{
					if ( strcmp(argv[i + 1], "on") == 0 )
					{
						BACKWARD_MODE = true;

						if ( prop_mode == NO_PROPAGATION )
						{
							prop_mode = BACKWARD_PROPAGATION;
						}
					}

				}
			}
		}

		if ( strcmp(argv[i], "--symmetric") == 0 )
		{
			sym_mode = SYMMETRIC;
			FORWARD_MODE = true;
			BACKWARD_MODE = true;
			prop_mode = FORWARD_BACKWARD_PROPAGATION;
		}
		else if ( strcmp(argv[i], "--skew-symmetric") == 0 )
		{
			sym_mode = SKEW_SYMMETRIC;
			FORWARD_MODE = true;
			BACKWARD_MODE = true;
			prop_mode = FORWARD_BACKWARD_PROPAGATION;
		}
	}

	manager = new ProgressionManager(mode, k, d, minN, maxN, r, sym_mode, prop_mode);

	manager->importArguments(argc, argv);

	manager->setBackwardPropagation(BACKWARD_MODE);
	manager->setForwardPropagation(FORWARD_MODE);

	while ( manager->readJob(stdin) >= 0 )
	{
		manager->doSearch();
		manager->reset();
	}

	delete manager;

	return 0;
}
